<?php

namespace App\Http\Controllers;

use App\Events\AttendenceEvent;
use App\Models\User;
use Illuminate\Http\Request;


class FileChangeController extends Controller
{
    public function handleFileChange(Request $request)
    {
        $rfid = $request->input('rfid');
        $created_at = $request->input('created_at');
        
        $user = User::where('rfid', $rfid)->first();

        if (!$user) {
            $user = User::create([
                'name' => 'Demo User ' . $rfid , 
                'rfid' => $rfid,
                'status' => true,
                'created_at' => $created_at
            ]);

            $action = 'Punch In';
        } else {
            $user->status = !$user->status;
            $action = $user->status ? 'Punch In' : 'Punch Out';

            // Save updated status
            $user->save();
        }

        // Broadcast the event with the user name and action
        broadcast(new AttendenceEvent("{$user->name} - {$action}"))->toOthers();

        // Return response
        return response()->json([
            'status' => 'success',
            'message' => "File content received successfully!",
            'action' => $action,
            'user' => $user->name,
        ], 200);
    }

    public function FileEvent(){
        broadcast(new AttendenceEvent('hello world'))->toOthers();
    }
}
